package com.biz.crm.cps.business.activity.actual.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeProductService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 活动奖励-奖品
 * @Author: zengxingwang
 * @Date: 2021/10/21 16:08
 */
@Api(tags = "活动奖励配置")
@Slf4j
@RestController
@RequestMapping("/v1/activity/prizeProduct")
public class RewardActivityPrizeProductController {

  @Autowired
  private RewardActivityPrizeProductService rewardActivityPrizeProductService;

  /**
   * 条件查询活动奖励-奖品列表
   */
  @ApiOperation(value = "条件查询活动奖励-奖品列表")
  @GetMapping(value="findByConditions")
  public Result<Page<RewardActivityPrizeProductEntity>> findByConditions(@RequestParam(value = "activityCode") String activityCode,
                                                                         @RequestParam(value = "prizeLevel") Integer prizeLevel,
                                                                         @PageableDefault(50) Pageable pageable) {
    try {
      Page<RewardActivityPrizeProductEntity> page = rewardActivityPrizeProductService.findByConditions(activityCode, prizeLevel, pageable);
      return Result.ok(page);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
