package com.biz.crm.cps.business.activity.actual.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 每日最大中奖数记录
 * @Author: zengxingwang
 * @Date: 2021/11/9 16:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "PrizeCountEntity", description = "每日最大中奖数记录")
@TableName("reward_activity_prize_count")
public class PrizeCountEntity extends UuidEntity {

  /**
   * 抽奖活动编码
   */
  @ApiModelProperty(name = "activityCode", value = "抽奖活动编码")
  @TableField(value = "activity_code")
  private String activityCode;

  /**
   * 奖项id
   */
  @ApiModelProperty(name = "prizeId", value = "奖项id")
  @TableField(value = "prize_id")
  private String prizeId;

  /**
   * 中奖次数
   */
  @ApiModelProperty(name = "count", value = "中奖次数")
  @TableField(value = "count")
  private BigDecimal count;

  /**
   * 时间
   */
  @ApiModelProperty(name = "dateTime", value = "时间")
  @TableField(value = "date_time")
  private Date dateTime;
}
