package com.biz.crm.cps.business.activity.actual.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;

/**
 * 活动奖励配置
 * @author zxw
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityEntity", description = "活动奖励配置")
@TableName("reward_activity")
public class RewardActivityEntity extends TenantFlagOpEntity {

  /**
   * 抽奖活动编码
   */
  @ApiModelProperty(name = "activityCode", value = "抽奖活动编码")
  @TableField(value = "activity_code")
  private String activityCode;

  /**
   * 抽奖活动名称
   */
  @ApiModelProperty(name = "activityName", value = "抽奖活动名称")
  @TableField(value = "activity_name")
  private String activityName;

  /**
   * 活动开始时间
   */
  @ApiModelProperty(name = "startTime", value = "活动开始时间")
  @TableField(value = "start_time")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date startTime;

  /**
   * 活动结束时间
   */
  @ApiModelProperty(name = "endTime", value = "活动结束时间")
  @TableField(value = "end_time")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date endTime;

  /**
   * 活动描述
   */
  @ApiModelProperty(name = "activityDescription", value = "活动描述")
  @TableField(value = "activity_description")
  private String activityDescription;

  /**
   * 产品维度
   */
  @ApiModelProperty(name = "productType", value = "产品维度")
  @TableField(value = "product_type")
  private String productType;

  /**
   * 产品
   */
  @ApiModelProperty("产品")
  @TableField(exist = false)
  private Set<RewardActivityProductEntity> productEntities;

  /**
   * 奖品信息
   */
  @ApiModelProperty("奖品信息")
  @TableField(exist = false)
  private Set<RewardActivityPrizeEntity> prize;

}
