package com.biz.crm.cps.business.activity.actual.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 活动奖励奖品配置
 * @Author: zengxingwang
 * @Date: 2021/10/19 11:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityPrizeEntity", description = "活动奖励奖品配置")
@TableName("reward_activity_prize")
public class RewardActivityPrizeEntity extends UuidEntity {

  /**
   * 奖品等级
   */
  @ApiModelProperty(name = "prizeLevel", value = "奖品等级")
  @TableField(value = "prize_level")
  private BigDecimal prizeLevel;

  /**
   * 奖品等级名称
   */
  @ApiModelProperty(name = "prizeLevelName", value = "奖品等级名称")
  @TableField(value = "prize_level_name")
  private String prizeLevelName;

  /**
   * 价值
   */
  @ApiModelProperty(name = "amount", value = "价值")
  @TableField(value = "amount")
  private BigDecimal amount;

  /**
   * 奖品
   */
  @ApiModelProperty("奖品")
  @TableField(exist = false)
  private Set<RewardActivityPrizeProductEntity> prizeProductEntities;

  /**
   * 奖品图片
   */
  @ApiModelProperty(name = "url", value = "奖品图片")
  @TableField(value = "url")
  private String url;

  /**
   * 奖品库存
   */
  @ApiModelProperty(name = "inventoryQuantity", value = "奖品库存")
  @TableField(value = "inventory_quantity")
  private BigDecimal inventoryQuantity;

  /**
   * 奖品剩余库存
   */
  @ApiModelProperty(name = "remainingInventoryQuantity", value = "奖品剩余库存")
  @TableField(value = "remaining_inventory_quantity")
  private BigDecimal remainingInventoryQuantity;

  /**
   * 奖励数量
   */
  @ApiModelProperty(name = "quantity", value = "奖励数量")
  @TableField(value = "quantity")
  private BigDecimal quantity;

  /**
   * 奖励数量上限
   */
  @ApiModelProperty(name = "maxQuantity", value = "奖励数量上限")
  @TableField(value = "max_quantity")
  private BigDecimal maxQuantity;

  /**
   * 中奖概率
   */
  @ApiModelProperty(name = "probability", value = "中奖概率")
  @TableField(value = "probability")
  private BigDecimal probability;

  /**
   * 设置终端反向奖励类型
   */
  @ApiModelProperty(name = "reverseType", value = "设置终端反向奖励类型")
  @TableField(value = "reverse_type")
  private Integer reverseType;

  /**
   * 所占格子数
   */
  @ApiModelProperty(name = "grids", value = "所占格子数")
  @TableField(value = "grids")
  private Integer grids;

  /**
   * 设置终端反向奖励
   */
  @ApiModelProperty(name = "reverse", value = "设置终端反向奖励")
  @TableField(value = "reverse")
  private BigDecimal reverse;

  /**
   * 配置
   */
  @ApiModelProperty("配置")
  @TableField(value = "reward_activity_id")
  private String rewardActivityId;
}
