package com.biz.crm.cps.business.activity.actual.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 活动奖励奖品
 * @Author: zengxingwang
 * @Date: 2021/10/19 16:04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityPrizeProductEntity", description = "活动奖励奖品")
@TableName("reward_activity_prize_product")
public class RewardActivityPrizeProductEntity extends UuidEntity {

  /**
   * 编码
   */
  @ApiModelProperty("编码")
  @TableField(value = "product_code")
  private String productCode;

  /**
   * 名称
   */
  @ApiModelProperty("名称")
  @TableField(value = "product_name")
  private String productName;

  /**
   * 图片
   */
  @ApiModelProperty("图片")
  @TableField(value = "product_url")
  private String productUrl;

  /**
   * 配置
   */
  @ApiModelProperty("配置")
  @TableField(value = "reward_activity_prize_id")
  private String rewardActivityPrizeId;

  /**
   * 奖励
   */
  @ApiModelProperty("奖励")
  @TableField(exist = false)
  private RewardActivityPrizeEntity prize;
}
