package com.biz.crm.cps.business.activity.actual.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 活动奖励参与产品配置
 * @Author: zengxingwang
 * @Date: 2021/10/19 11:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityProductEntity", description = "活动奖励参与产品配置")
@TableName("reward_activity_product")
public class RewardActivityProductEntity extends UuidEntity {

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 产品名称
   */
  @ApiModelProperty("产品名称")
  @TableField(value = "material_name")
  private String materialName;

  /**
   * 配置
   */
  @ApiModelProperty("配置")
  @TableField(value = "reward_activity_id")
  private String rewardActivityId;

  /**
   * 奖励活动
   */
  @ApiModelProperty("奖励活动")
  @TableField(exist = false)
  private RewardActivityEntity activity;
}
