package com.biz.crm.cps.business.activity.actual.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.activity.actual.local.entity.PrizeCountEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 每日最大中奖数记录mybatis实现
 * @Author: zengxingwang
 * @Date: 2021/11/9 16:30
 */
public interface PrizeCountMapper extends BaseMapper<PrizeCountEntity> {

  /**
   * 查询每日最大中奖数
   * @param activityCode
   * @return
   */
  List<PrizeCountEntity> findByActivityCodeAndTime(@Param("activityCode") String activityCode);

  /**
   * 查询
   * @param activityCode
   * @param date
   * @param prizeId
   * @return
   */
  PrizeCountEntity findByActivityCodeAndTimeAndPrizeId(@Param("activityCode") String activityCode, @Param("date") String date, @Param("prizeId") String prizeId);

  /**
   * 修改
   * @param activityCode
   * @param date
   * @param prizeId
   */
  void updateCountByActivityCodeAndTimeAndPrizeId(@Param("activityCode") String activityCode, @Param("date") String date, @Param("prizeId") String prizeId);
}
