package com.biz.crm.cps.business.activity.actual.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityDto;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * 活动奖励配置mybatis实现
 * @Author: zengxingwang
 * @Date: 2021/10/19 16:31
 */
public interface RewardActivityActualMapper extends BaseMapper<RewardActivityEntity> {

  /**
   * 条件查询活动奖励配置列表
   * @param dto
   * @param page
   * @return
   */
  Page<RewardActivityEntity> findByConditions(@Param("dto") RewardActivityDto dto, Page<RewardActivityEntity> page);

  /**
   * 创建时活动重复验证
   * @param productCods
   * @param startTime
   * @param endTime
   * @return
   */
  long findByProductsAndDate(@Param("productCods") List<String> productCods, @Param("startTime") Date startTime, @Param("endTime")Date endTime);

  /**
   * 编辑时活动重复验证
   * @param productCods
   * @param startTime
   * @param endTime
   * @param id
   * @return
   */
  long findByProductsAndDateAndId(@Param("productCods") List<String> productCods, @Param("startTime") Date startTime, @Param("endTime") Date endTime, @Param("id") String id);

  /**
   * 获取当前时间的活动
   * @param date
   * @return
   */
  RewardActivityEntity findByTime(@Param("productCode") String productCode, @Param("date") Date date);
}
