package com.biz.crm.cps.business.activity.actual.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;
import org.apache.ibatis.annotations.Param;

import java.util.LinkedHashSet;

/**
 * 奖品等级信息mybatis实现
 * @Author: zengxingwang
 * @Date: 2021/10/21 9:54
 */
public interface RewardActivityPrizeMapper extends BaseMapper<RewardActivityPrizeEntity> {

  /**
   * 根据配置活动查询参与奖项信息(包含关联)
   * @param id
   * @return
   */
  LinkedHashSet<RewardActivityPrizeEntity> findDetailByRewardActivityId(@Param("id") String id);

  /**
   * 根据活动编码+奖项查询
   * @param activityCode
   * @param amount
   * @return
   */
  RewardActivityPrizeEntity findByActivityCodeAndPrizeLevel(@Param("activityCode") String activityCode, @Param("amount") Integer amount);

  void updateInventoryById(@Param("id") String id);
}
