package com.biz.crm.cps.business.activity.actual.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.actual.local.entity.PrizeCountEntity;
import com.biz.crm.cps.business.activity.actual.local.mapper.PrizeCountMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 每日最大中奖数记录持久化
 * @Author: zengxingwang
 * @Date: 2021/11/9 16:30
 */
@Component
public class PrizeCountRepository extends ServiceImpl<PrizeCountMapper, PrizeCountEntity> {

  @Autowired
  private PrizeCountMapper prizeCountMapper;
  /**
   * 查询每日最大中奖数
   * @param activityCode
   * @return
   */
  public List<PrizeCountEntity> findByActivityCodeAndTime(String activityCode) {
    return prizeCountMapper.findByActivityCodeAndTime(activityCode);
  }

  /**
   * 查询
   * @param activityCode
   * @param date
   * @param prizeId
   * @return
   */
  public PrizeCountEntity findByActivityCodeAndTimeAndPrizeId(String activityCode, String date, String prizeId) {
    return prizeCountMapper.findByActivityCodeAndTimeAndPrizeId(activityCode, date, prizeId);
  }

  /**
   * 修改
   * @param activityCode
   * @param date
   * @param prizeId
   */
  public void updateCountByActivityCodeAndTimeAndPrizeId(String activityCode, String date, String prizeId) {
    prizeCountMapper.updateCountByActivityCodeAndTimeAndPrizeId(activityCode, date, prizeId);
  }
}
