package com.biz.crm.cps.business.activity.actual.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.local.mapper.RewardActivityActualMapper;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * 活动奖励配置实现持久化
 * @Author: zengxingwang
 * @Date: 2021/10/19 16:29
 */
@Component
public class RewardActivityActualRepository extends ServiceImpl<RewardActivityActualMapper, RewardActivityEntity> {

  @Autowired
  private RewardActivityActualMapper rewardActivityMapper;

  /**
   * 条件查询活动奖励配置列表
   * @param dto
   * @param pageable
   * @return
   */
  public Page<RewardActivityEntity> findByConditions(RewardActivityDto dto, Pageable pageable) {
    Page<RewardActivityEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return rewardActivityMapper.findByConditions(dto, page);
  }

  /**
   * 根据id查询
   * @param id
   * @return
   */
  public RewardActivityEntity findById(String id) {
    QueryWrapper<RewardActivityEntity> wrapper = new QueryWrapper();
    wrapper.eq("id", id);
    return this.getOne(wrapper);
  }

  /**
   * 创建时活动重复验证
   * @param productCods
   * @param startTime
   * @param endTime
   * @return
   */
  public long findByProductsAndDate(List<String> productCods, Date startTime, Date endTime) {
    return rewardActivityMapper.findByProductsAndDate(productCods, startTime, endTime);
  }

  /**
   * 编辑时活动重复验证
   * @param productCods
   * @param startTime
   * @param endTime
   * @param id
   * @return
   */
  public long findByProductsAndDateAndId(List<String> productCods, Date startTime, Date endTime, String id) {
    return rewardActivityMapper.findByProductsAndDateAndId(productCods, startTime, endTime, id);
  }

  /**
   * 批量根据id禁用
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIds(EnableStatusEnum enable, List<String> ids) {
    UpdateWrapper<RewardActivityEntity> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("enable_status", enable.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 批量根据编码查询详情
   * @param activityCode
   * @return
   */
  public RewardActivityEntity findByActivityCode(String activityCode) {
    QueryWrapper<RewardActivityEntity> wrapper = new QueryWrapper();
    wrapper.eq("activity_code", activityCode);
    return this.getOne(wrapper);
  }

  /**
   * 获取当前时间的活动
   * @param date
   * @return
   */
  public RewardActivityEntity findByTime(String productCode, Date date) {
    return rewardActivityMapper.findByTime(productCode, date);
  }
}
