package com.biz.crm.cps.business.activity.actual.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.mapper.RewardActivityPrizeProductMapper;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 奖品信息持久化处理
 * @Author: zengxingwang
 * @Date: 2021/10/21 10:05
 */
@Component
public class RewardActivityPrizeProductRepository extends ServiceImpl<RewardActivityPrizeProductMapper, RewardActivityPrizeProductEntity> {

  @Autowired
  private RewardActivityPrizeProductMapper rewardActivityPrizeProductMapper;

  /**
   * 条件查询活动奖励-奖品列表
   * @param activityCode
   * @param prizeLevel
   * @param pageable
   * @return
   */
  public Page<RewardActivityPrizeProductEntity> findByConditions(String activityCode, Integer prizeLevel, Pageable pageable) {
    Page<RewardActivityPrizeProductEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return rewardActivityPrizeProductMapper.findByConditions(activityCode, prizeLevel, page);
  }

  /**
   * 根据奖项id查询奖品信息
   * @param id
   * @return
   */
  public Set<RewardActivityPrizeProductEntity> findByRewardActivityPrizeId(String id) {
    QueryWrapper<RewardActivityPrizeProductEntity> wrapper = new QueryWrapper();
    wrapper.eq("reward_activity_prize_id", id);
    return Sets.newHashSet(this.list(wrapper));
  }
}
