package com.biz.crm.cps.business.activity.actual.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;
import com.biz.crm.cps.business.activity.actual.local.mapper.RewardActivityPrizeMapper;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 奖励等级信息持久化处理
 * @Author: zengxingwang
 * @Date: 2021/10/21 9:52
 */
@Component
public class RewardActivityPrizeRepository extends ServiceImpl<RewardActivityPrizeMapper, RewardActivityPrizeEntity> {

  @Autowired
  private RewardActivityPrizeMapper rewardActivityPrizeMapper;

  /**
   * 根据配置活动查询参与奖项信息
   * @param id
   * @return
   */
  public Set<RewardActivityPrizeEntity> findByRewardActivityId(String id) {
    QueryWrapper<RewardActivityPrizeEntity> wrapper = new QueryWrapper();
    wrapper.eq("reward_activity_id", id);
    return Sets.newHashSet(this.list(wrapper));
  }

  public Set<RewardActivityPrizeEntity> findByActivityCode(String activityCode) {
    QueryWrapper<RewardActivityPrizeEntity> wrapper = new QueryWrapper();
    wrapper.eq("activity_code", activityCode);
    return Sets.newHashSet(this.list(wrapper));
  }

  /**
   * 根据配置活动查询参与奖项信息(包含关联)
   * @param id
   * @return
   */
  public LinkedHashSet<RewardActivityPrizeEntity> findDetailByRewardActivityId(String id) {
    return rewardActivityPrizeMapper.findDetailByRewardActivityId(id);
  }

  /**
   * 根据活动编码+奖项查询
   * @param activityCode
   * @param amount
   * @return
   */
  public RewardActivityPrizeEntity findByActivityCodeAndPrizeLevel(String activityCode, Integer amount) {
    return rewardActivityPrizeMapper.findByActivityCodeAndPrizeLevel(activityCode, amount);
  }

  /**
   * 修改库存
   * @param id
   */
  public void updateInventoryById(String id) {
    rewardActivityPrizeMapper.updateInventoryById(id);
  }
}
