package com.biz.crm.cps.business.activity.actual.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityProductEntity;
import com.biz.crm.cps.business.activity.actual.local.mapper.RewardActivityProductMapper;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 奖励活动参与商品持久化
 * @Author: zengxingwang
 * @Date: 2021/10/21 9:35
 */
@Component
public class RewardActivityProductRepository extends ServiceImpl<RewardActivityProductMapper, RewardActivityProductEntity> {

  /**
   * 根据配置活动查询参与产品信息
   * @param id
   * @return
   */
  public Set<RewardActivityProductEntity> findByRewardActivityId(String id) {
    QueryWrapper<RewardActivityProductEntity> wrapper = new QueryWrapper();
    wrapper.eq("reward_activity_id", id);
    return Sets.newHashSet(this.list(wrapper));
  }
}
