package com.biz.crm.cps.business.activity.actual.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动奖励配置接口定义
 * @Author: zengxingwang
 * @Date: 2021/10/19 16:24
 */
public interface RewardActivityActualService {

  /**
   * 创建活动奖励配置
   * @param rewardActivity
   * @return
   */
  RewardActivityEntity create(RewardActivityEntity rewardActivity);

  /**
   * 条件查询活动奖励配置列表
   * @param dto
   * @param pageable
   * @return
   */
  Page<RewardActivityEntity> findByConditions(RewardActivityDto dto, Pageable pageable);

  /**
   * 编辑活动奖励配置
   * @param rewardActivity
   * @return
   */
  RewardActivityEntity update(RewardActivityEntity rewardActivity);

  /**
   * 批量根据id禁用
   * @param ids
   */
  void disable(List<String> ids);

  /**
   * 批量根据id启用
   * @param ids
   */
  void enable(List<String> ids);

  /**
   * 批量根据id查询详情（包括关联信息）
   * @param id
   * @return
   */
  RewardActivityEntity findDetailById(String id);

  /**
   * 批量根据编码查询详情
   * @param activityCode
   * @return
   */
  RewardActivityEntity findByActivityCode(String activityCode);

  /**
   * 获取当前时间的活动（包括关联信息）
   * @return
   */
  RewardActivityEntity findDetailByTime(String productCode);
}
