package com.biz.crm.cps.business.activity.actual.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import org.springframework.data.domain.Pageable;

import java.util.Set;

/**
 * 奖品接口定义
 * @Author: zengxingwang
 * @Date: 2021/10/21 10:00
 */
public interface RewardActivityPrizeProductService {

  /**
   * 批量保存奖品
   * @param set
   */
  void createBatch(Set<RewardActivityPrizeProductEntity> set);

  /**
   * 条件查询活动奖励-奖品列表
   * @param activityCode
   * @param prizeLevel
   * @param pageable
   * @return
   */
  Page<RewardActivityPrizeProductEntity> findByConditions(String activityCode, Integer prizeLevel, Pageable pageable);

  /**
   * 根据奖项id查询奖品信息
   * @param id
   * @return
   */
  Set<RewardActivityPrizeProductEntity> findByRewardActivityPrizeId(String id);
}
