package com.biz.crm.cps.business.activity.actual.local.service;

import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 奖励等级信息接口定义
 * @Author: zengxingwang
 * @Date: 2021/10/21 9:20
 */
public interface RewardActivityPrizeService {

  /**
   * 批量设置奖项信息
   * @param prize
   */
  void createBatch(Set<RewardActivityPrizeEntity> prize);

  /**
   * 修改奖项信息
   * @param prize
   */
  void updateBatch(Set<RewardActivityPrizeEntity> prize);

  /**
   * 根据配置活动查询参与奖项信息（包括奖品）
   * @param id
   * @return
   */
  LinkedHashSet<RewardActivityPrizeEntity> findDetailByRewardActivityId(String id);

  /**
   * 根据配置活动编码查询参与奖项信息（包括奖品）
   * @param activityCode
   * @return
   */
  Set<RewardActivityPrizeEntity> findDetailByActivityCode(String activityCode);

  /**
   * 根据活动编码+奖项查询
   * @param activityCode
   * @param amount
   * @return
   */
  RewardActivityPrizeEntity findByActivityCodeAndPrizeLevel(String activityCode, Integer amount);

  /**
   * 修改库存
   * @param id
   */
  void updateInventoryById(String id);
}
