package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.biz.crm.cps.business.activity.actual.local.entity.PrizeCountEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.PrizeCountRepository;
import com.biz.crm.cps.business.activity.actual.local.service.PrizeCountService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 每日最大中奖数记录接口定义实现
 * @Author: zengxingwang
 * @Date: 2021/11/9 16:33
 */
@Service
public class PrizeCountServiceImpl implements PrizeCountService {

  @Autowired
  private PrizeCountRepository prizeCountRepository;

  /**
   * 查询每日最大中奖数
   * @param activityCode
   * @return
   */
  public List<PrizeCountEntity> findByActivityCodeAndTime(String activityCode) {
    if(StringUtils.isBlank(activityCode)){
      return Lists.newArrayList();
    }
    return prizeCountRepository.findByActivityCodeAndTime(activityCode);
  }

  /**
   * 保存
   * @param activityCode
   * @param prizeId
   */
  @Override
  @Transactional
  public void save(String activityCode, String prizeId) {
    Validate.notBlank(activityCode, "活动编码不能为空");
    Validate.notBlank(prizeId, "奖项id不能为空");
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    String date = format.format(new Date());
    PrizeCountEntity prizeCountEntity = prizeCountRepository.findByActivityCodeAndTimeAndPrizeId(activityCode, date, prizeId);
    if(prizeCountEntity == null){
      prizeCountEntity = new  PrizeCountEntity();
      prizeCountEntity.setActivityCode(activityCode);
      prizeCountEntity.setPrizeId(prizeId);
      Date parse = null;
      try {
        parse = format.parse(date);
      } catch (ParseException e) {
        e.printStackTrace();
      }
      prizeCountEntity.setDateTime(parse);
      prizeCountEntity.setCount(BigDecimal.ONE);
      prizeCountRepository.save(prizeCountEntity);
    }else {
      prizeCountRepository.updateCountByActivityCodeAndTimeAndPrizeId(activityCode, date, prizeId);
    }
  }
}
