package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityActualVoRepository;
import com.biz.crm.cps.business.activity.actual.sdk.service.RewardActivityActualVoService;
import com.biz.crm.cps.business.activity.sdk.vo.RewardActivityRecordVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/25 17:34
 */
@Service
public class RewardActivityActualVoServiceImpl implements RewardActivityActualVoService {

  @Autowired
  private RewardActivityActualVoRepository rewardActivityActualVoRepository;

  /**
   * 根据参与品和时间查找活动
   * @param productCode
   * @param date
   * @return
   */
  @Override
  public RewardActivityRecordVo findByProductCodeAndTime(String productCode, Date date) {
    if(StringUtils.isBlank(productCode) || date == null){
      return null;
    }
    return rewardActivityActualVoRepository.findByProductCodeAndTime(productCode, date);
  }
}
