package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityPrizeProductRepository;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeProductService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Set;

/**
 * 奖品接口定义实现
 * @Author: zengxingwang
 * @Date: 2021/10/21 10:01
 */
@Service
public class RewardActivityPrizeProductServiceImpl implements RewardActivityPrizeProductService {

  @Autowired
  private RewardActivityPrizeProductRepository rewardActivityPrizeProductRepository;
  /**
   * 批量保存奖品
   * @param set
   */
  @Override
  @Transactional
  public void createBatch(Set<RewardActivityPrizeProductEntity> set) {
    this.validate(set);
    rewardActivityPrizeProductRepository.saveBatch(set);
  }

  /**
   * 条件查询活动奖励-奖品列表
   * @param activityCode
   * @param prizeLevel
   * @param pageable
   * @return
   */
  @Override
  public Page<RewardActivityPrizeProductEntity> findByConditions(String activityCode, Integer prizeLevel, Pageable pageable) {
    if(StringUtils.isBlank(activityCode) || prizeLevel == null){
      return new Page<>();
    }
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    return rewardActivityPrizeProductRepository.findByConditions(activityCode, prizeLevel, pageable);
  }

  /**
   * 根据奖项id查询奖品信息
   * @param id
   * @return
   */
  @Override
  public Set<RewardActivityPrizeProductEntity> findByRewardActivityPrizeId(String id) {
    if(StringUtils.isBlank(id)){
      return Sets.newHashSet();
    }
    return rewardActivityPrizeProductRepository.findByRewardActivityPrizeId(id);
  }

  /**
   * 验证数据
   * @param set
   */
  private void validate(Set<RewardActivityPrizeProductEntity> set) {
    Validate.notEmpty(set, "奖品信息不能为空");
    for(RewardActivityPrizeProductEntity item : set){
      Validate.notBlank(item.getProductCode(), "奖品编码不能为空");
      Validate.notBlank(item.getProductName(), "奖品名称不能为空");
    }
  }
}
