package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityProductEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityProductRepository;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityProductService;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Set;

/**
 * 奖励活动参与商品接口实现
 * @Author: zengxingwang
 * @Date: 2021/10/19 16:51
 */
@Service
public class RewardActivityProductServiceImpl implements RewardActivityProductService {

  @Autowired
  private RewardActivityProductRepository rewardActivityProductRepository;

  /**
   * 创建奖励活动参与商品
   * @param productEntities
   */
  @Override
  @Transactional
  public void createBatch(Set<RewardActivityProductEntity> productEntities) {
    this.validate(productEntities);
    rewardActivityProductRepository.saveBatch(productEntities);
  }

  /**
   * 根据配置活动查询参与产品信息
   * @param id
   * @return
   */
  @Override
  public Set<RewardActivityProductEntity> findByRewardActivityId(String id) {
    if(StringUtils.isBlank(id)){
      return Sets.newHashSet();
    }
    return rewardActivityProductRepository.findByRewardActivityId(id);
  }

  /**
   * 数据验证
   * @param productEntities
   */
  private void validate(Set<RewardActivityProductEntity> productEntities) {
    Validate.notEmpty(productEntities, "奖励活动参与商品信息不能为空");
    for(RewardActivityProductEntity item : productEntities){
      Validate.notBlank(item.getMaterialCode(), "产品编码不能为空");
      Validate.notBlank(item.getMaterialName(), "产品名称不能为空");
    }
  }
}
