package com.biz.crm.cps.business.activity.actual.local.service.notifier;

import com.biz.crm.cps.business.activity.actual.sdk.service.RewardActivityActualVoService;
import com.biz.crm.cps.business.activity.sdk.event.ScanCodeActivityEventListener;
import com.biz.crm.cps.business.activity.sdk.vo.RewardActivityRecordVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/25 17:25
 */
@Component
public class ActivityActualEventListenerImpl implements ScanCodeActivityEventListener {

  @Autowired
  private RewardActivityActualVoService rewardActivityActualVoService;

  /**
   * 根据参与品和时间查找活动
   * @param productCode
   * @param date
   * @return
   */
  @Override
  public RewardActivityRecordVo onFindActivity(String productCode, Date date) {
    if(StringUtils.isBlank(productCode) || date == null){
      return null;
    }
    return rewardActivityActualVoService.findByProductCodeAndTime(productCode, date);
  }
}
