package com.biz.crm.cps.business.activity.actual.local.service.observer;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.activity.actual.local.entity.PrizeCountEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.service.PrizeCountService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityActualService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeProductService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeService;
import com.biz.crm.cps.business.activity.actual.sdk.event.RandomQuotaComputeEventListener;
import com.biz.crm.cps.business.activity.sdk.constant.RewardTypeEnum;
import com.biz.crm.cps.business.activity.sdk.dto.ActivityRandomDto;
import com.biz.crm.cps.business.activity.sdk.dto.ActivityRewardConditionDto;
import com.biz.crm.cps.business.activity.sdk.dto.LotteryDto;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityMountRegister;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityRewardServiceObserver;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityServiceObserver;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 活动抽奖
 * @Author: zengxingwang
 * @Date: 2021/10/26 9:50
 */
@Service
public class ActualActivityServiceObserverImpl implements ActivityServiceObserver {

  @Autowired
  @Qualifier("RewardActivityActualMountRegisterServiceImpl")
  private ActivityMountRegister activityMountRegister;
  @Autowired(required = false)
  private List<RandomQuotaComputeEventListener> randomQuotaComputeEventListeners;
  @Autowired
  private RewardActivityPrizeService rewardActivityPrizeService;
  @Autowired
  private ActivityRewardServiceObserver activityRewardServiceObserver;
  @Autowired
  private PrizeCountService prizeCountService;
  @Autowired
  private RewardActivityPrizeProductService rewardActivityPrizeProductService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private RewardActivityActualService rewardActivityActualService;
  /**
   * 活动抽奖
   * @param lotteryDto
   * @return
   */
  @Override
  @Transactional
  public Integer onLottery(LotteryDto lotteryDto) {
    Validate.notNull(lotteryDto, "奖励条件信息不能为空！");
    Validate.notBlank(lotteryDto.getActivityMethodFlag(), "活动方式不能为空！");
    Validate.notBlank(lotteryDto.getActivityCode(), "活动编码不能为空！");
    Validate.notBlank(lotteryDto.getParticipatorCode(), "参与者编码不能为空！");
    // 1根据奖励方式判断是否计算
    if (StringUtil.equals(lotteryDto.getActivityMethodFlag(), activityMountRegister.getFlag())) {
      List<ActivityRandomDto> params = new ArrayList<>();
      Set<RewardActivityPrizeEntity> prizes = rewardActivityPrizeService.findDetailByActivityCode(lotteryDto.getActivityCode());
      //查询各奖项中奖次数
      Map<String, BigDecimal> map = new HashMap<>();
      List<PrizeCountEntity> prizeCount = prizeCountService.findByActivityCodeAndTime(lotteryDto.getActivityCode());
      if(!CollectionUtils.isEmpty(prizeCount)) {
        for (PrizeCountEntity entity : prizeCount) {
          map.put(entity.getPrizeId(), entity.getCount());
        }
      }
      for (RewardActivityPrizeEntity prize : prizes) {
        BigDecimal integer = map.get(prize.getId());
        BigDecimal count = integer == null ? BigDecimal.ZERO : integer;
        if (BigDecimal.ONE.compareTo(prize.getPrizeLevel()) == 0) {
          ActivityRandomDto dto = new ActivityRandomDto();
          dto.setCash(prize.getPrizeLevel());
          dto.setPercent(prize.getProbability());
          params.add(dto);
        }else {
          if (count.compareTo(prize.getMaxQuantity()) == -1 && BigDecimal.ZERO.compareTo(prize.getRemainingInventoryQuantity()) == -1) {
            ActivityRandomDto dto = new ActivityRandomDto();
            dto.setCash(prize.getPrizeLevel());
            dto.setPercent(prize.getProbability());
            params.add(dto);
          }
        }
      }
      if (!CollectionUtils.isEmpty(this.randomQuotaComputeEventListeners)) {
        for (RandomQuotaComputeEventListener randomQuotaComputeEventListener : this.randomQuotaComputeEventListeners) {
          BigDecimal amount = randomQuotaComputeEventListener.onExecute(params);
          if(amount != null){
            if(amount.intValue() != 1){
              //扣减库存
              RewardActivityPrizeEntity prizeEntity =rewardActivityPrizeService.findByActivityCodeAndPrizeLevel(lotteryDto.getActivityCode(), amount.intValue());
              rewardActivityPrizeService.updateInventoryById(prizeEntity.getId());
              //生成流水
              List<ActivityRewardConditionDto> list = this.buildDto(lotteryDto, prizeEntity);
              activityRewardServiceObserver.createRewardRecord(list);
              //每日最大数
              prizeCountService.save(lotteryDto.getActivityCode(), prizeEntity.getId());
            }
            return amount.intValue();
          }
        }
      }
    }
    return null;
  }

  /**
   * 组装数据
   * @param lotteryDto
   * @param prizeEntity
   * @return
   */
  private List<ActivityRewardConditionDto> buildDto(LotteryDto lotteryDto, RewardActivityPrizeEntity prizeEntity) {
    RewardActivityEntity activityEntity = this.rewardActivityActualService.findByActivityCode(lotteryDto.getActivityCode());
    Set<RewardActivityPrizeProductEntity> prizeProduct = rewardActivityPrizeProductService.findByRewardActivityPrizeId(prizeEntity.getId());
    List<ActivityRewardConditionDto> list = new ArrayList<>();
    if(!CollectionUtils.isEmpty(prizeProduct)){
      LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      for(RewardActivityPrizeProductEntity item : prizeProduct){
        ActivityRewardConditionDto dto = new ActivityRewardConditionDto();
        dto.setAwardConditionFlag("fixedAmount");
        dto.setRewardData("1");
        dto.setParticipatorFlag(ParticipatorTypeEnum.getByKey(loginUser.getUsertype()).getDictCode());
        dto.setParticipatorName(loginUser.getConsumerName());
        dto.setRewardMethodFlag("gift");
        dto.setRewardMethodName(lotteryDto.getRewardMethodName());
        dto.setActualParticipatorCode(loginUser.getConsumerCode());
        dto.setActualParticipatorFlag(lotteryDto.getActualParticipatorFlag());
        dto.setGiftCode(item.getProductCode());
        dto.setTriggerAction("activityReward");
        dto.setTriggerObject(lotteryDto.getActivityCode());
        dto.setRewardCode(prizeEntity.getId());
        dto.setRecordCode(lotteryDto.getRecordCode());
        dto.setPolicyName(activityEntity == null ? null : activityEntity.getActivityName());
        list.add(dto);
      }
      //反向
      if(prizeEntity.getReverseType() != null && prizeEntity.getReverse() != null) {
        List<ActivityRewardConditionDto> reverseList = new ArrayList<>();
        ActivityRewardConditionDto reverseDto = new ActivityRewardConditionDto();
        //默认终端
        reverseDto.setParticipatorFlag("2");
        reverseDto.setAwardConditionFlag("fixedAmount");
        reverseDto.setParticipatorName(loginUser.getConsumerName());
        reverseDto.setRewardMethodName(lotteryDto.getRewardMethodName());
        reverseDto.setActualParticipatorFlag(lotteryDto.getParticipatorFlag());
        reverseDto.setActualParticipatorCode(loginUser.getConsumerCode());
        RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getByDictCode(prizeEntity.getReverseType().toString());
        reverseDto.setRewardMethodFlag(rewardTypeEnum.getKey());
        reverseDto.setRewardData(prizeEntity.getReverse().toString());
        reverseDto.setTriggerAction("activityRewardReverse");
        reverseDto.setRecordCode(lotteryDto.getRecordCode());
        reverseDto.setPolicyName(activityEntity == null ? null : activityEntity.getActivityName());
        reverseList.add(reverseDto);
        ActivityRewardConditionDto activityRewardConditionDto = list.get(0);
        activityRewardConditionDto.setActivityRewardConditionDtos(reverseList);
      }
    }
    return list;
  }
}
