/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.biz.crm.cps.business.activity.actual.local.entity.PrizeCountEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.PrizeCountRepository;
import com.biz.crm.cps.business.activity.actual.local.service.PrizeCountService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrizeCountServiceImpl
implements PrizeCountService {
    @Autowired
    private PrizeCountRepository prizeCountRepository;

    @Override
    public List<PrizeCountEntity> findByActivityCodeAndTime(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return Lists.newArrayList();
        }
        return this.prizeCountRepository.findByActivityCodeAndTime(activityCode);
    }

    @Override
    @Transactional
    public void save(String activityCode, String prizeId) {
        Validate.notBlank((CharSequence)activityCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prizeId, (String)"\u5956\u9879id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(new Date());
        PrizeCountEntity prizeCountEntity = this.prizeCountRepository.findByActivityCodeAndTimeAndPrizeId(activityCode, date, prizeId);
        if (prizeCountEntity == null) {
            prizeCountEntity = new PrizeCountEntity();
            prizeCountEntity.setActivityCode(activityCode);
            prizeCountEntity.setPrizeId(prizeId);
            Date parse = null;
            try {
                parse = format.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            prizeCountEntity.setDateTime(parse);
            prizeCountEntity.setCount(BigDecimal.ONE);
            this.prizeCountRepository.save((Object)prizeCountEntity);
        } else {
            this.prizeCountRepository.updateCountByActivityCodeAndTimeAndPrizeId(activityCode, date, prizeId);
        }
    }
}

