/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityPrizeRepository;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityActualService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeProductService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeService;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RewardActivityPrizeServiceImpl
implements RewardActivityPrizeService {
    @Autowired
    private RewardActivityPrizeRepository rewardActivityPrizeRepository;
    @Autowired
    private RewardActivityPrizeProductService rewardActivityPrizeProductService;
    @Autowired
    private RewardActivityActualService rewardActivityActualService;

    @Override
    @Transactional
    public void createBatch(Set<RewardActivityPrizeEntity> prize) {
        this.createValidate(prize);
        this.rewardActivityPrizeRepository.saveBatch(prize);
        HashSet<RewardActivityPrizeProductEntity> set = new HashSet<RewardActivityPrizeProductEntity>();
        for (RewardActivityPrizeEntity item : prize) {
            Set<RewardActivityPrizeProductEntity> prizeProductEntities = item.getPrizeProductEntities();
            prizeProductEntities.stream().forEach(prizeProduct -> prizeProduct.setRewardActivityPrizeId(item.getId()));
            set.addAll(prizeProductEntities);
        }
        this.rewardActivityPrizeProductService.createBatch(set);
    }

    @Override
    @Transactional
    public void updateBatch(Set<RewardActivityPrizeEntity> prize) {
        this.updateValidate(prize);
        this.rewardActivityPrizeRepository.updateBatchById(prize);
    }

    @Override
    public LinkedHashSet<RewardActivityPrizeEntity> findDetailByRewardActivityId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet<RewardActivityPrizeEntity> prizeEntities = this.rewardActivityPrizeRepository.findDetailByRewardActivityId(id);
        if (CollectionUtils.isEmpty(prizeEntities)) {
            return Sets.newLinkedHashSet();
        }
        return prizeEntities;
    }

    @Override
    public Set<RewardActivityPrizeEntity> findDetailByActivityCode(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return Sets.newHashSet();
        }
        RewardActivityEntity activityEntity = this.rewardActivityActualService.findByActivityCode(activityCode);
        if (activityEntity == null) {
            return Sets.newHashSet();
        }
        LinkedHashSet<RewardActivityPrizeEntity> prizeEntities = this.rewardActivityPrizeRepository.findDetailByRewardActivityId(activityEntity.getId());
        return prizeEntities;
    }

    @Override
    public RewardActivityPrizeEntity findByActivityCodeAndPrizeLevel(String activityCode, Integer amount) {
        if (StringUtils.isBlank((CharSequence)activityCode) || amount == null) {
            return null;
        }
        return this.rewardActivityPrizeRepository.findByActivityCodeAndPrizeLevel(activityCode, amount);
    }

    @Override
    @Transactional
    public void updateInventoryById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u4fee\u6539\u5e93\u5b58\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rewardActivityPrizeRepository.updateInventoryById(id);
    }

    private void updateValidate(Set<RewardActivityPrizeEntity> prize) {
        Validate.notEmpty(prize, (String)"\u5956\u52b1\u7b49\u7ea7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer grids = 0;
        BigDecimal probability = BigDecimal.ZERO;
        for (RewardActivityPrizeEntity item : prize) {
            Validate.notNull((Object)item.getId(), (String)"\u5956\u52b1\u7b49\u7ea7\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (item.getPrizeLevel() != BigDecimal.ONE) {
                Validate.notBlank((CharSequence)item.getUrl(), (String)"\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Validate.notNull((Object)item.getPrizeLevel(), (String)"\u5956\u52b1\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getProbability(), (String)"\u4e2d\u5956\u6982\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getGrids(), (String)"\u683c\u5b50\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            probability = probability.add(item.getProbability());
            grids = grids + item.getGrids();
        }
        Validate.isTrue((grids <= 12 ? 1 : 0) != 0, (String)"\u683c\u5b50\u603b\u6570\u4e0d\u80fd\u8d85\u8fc712", (Object[])new Object[0]);
        Validate.isTrue((probability.compareTo(new BigDecimal(100)) == 0 ? 1 : 0) != 0, (String)"\u6982\u7387\u4e0d\u80fd\u8d85\u8fc7100%", (Object[])new Object[0]);
    }

    private void createValidate(Set<RewardActivityPrizeEntity> prize) {
        Validate.notEmpty(prize, (String)"\u5956\u52b1\u7b49\u7ea7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer grids = 0;
        BigDecimal probability = BigDecimal.ZERO;
        for (RewardActivityPrizeEntity item : prize) {
            if (item.getPrizeLevel() != BigDecimal.ONE) {
                Validate.notBlank((CharSequence)item.getUrl(), (String)"\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Validate.notNull((Object)item.getPrizeLevel(), (String)"\u5956\u52b1\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getProbability(), (String)"\u4e2d\u5956\u6982\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)item.getGrids(), (String)"\u683c\u5b50\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            probability = probability.add(item.getProbability());
            grids = grids + item.getGrids();
        }
        Validate.isTrue((grids <= 12 ? 1 : 0) != 0, (String)"\u683c\u5b50\u603b\u6570\u4e0d\u80fd\u8d85\u8fc712", (Object[])new Object[0]);
        Validate.isTrue((probability.compareTo(new BigDecimal(100)) == 0 ? 1 : 0) != 0, (String)"\u6982\u7387\u4e0d\u80fd\u8d85\u8fc7100%", (Object[])new Object[0]);
    }
}

