/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityProductEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityActualRepository;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityActualService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityProductService;
import com.biz.crm.cps.business.activity.actual.sdk.dto.RewardActivityDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RewardActivityActualServiceImpl
implements RewardActivityActualService {
    @Autowired
    private RewardActivityActualRepository rewardActivityRepository;
    @Autowired
    private RewardActivityProductService rewardActivityProductService;
    @Autowired
    private RewardActivityPrizeService rewardActivityPrizeService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public RewardActivityEntity create(RewardActivityEntity rewardActivity) {
        this.createValidate(rewardActivity);
        Set<RewardActivityProductEntity> productEntities = rewardActivity.getProductEntities();
        Set<RewardActivityPrizeEntity> prize = rewardActivity.getPrize();
        if (Objects.nonNull(this.generateCodeService)) {
            rewardActivity.setActivityCode((String)this.generateCodeService.generateCode("reward_activity_code", 1).get(0));
        }
        rewardActivity.setTenantCode(TenantUtils.getTenantCode());
        rewardActivity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        rewardActivity.setDelFlag(EnableStatusEnum.ENABLE.getCode());
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Date date = new Date();
        rewardActivity.setCreateAccount(loginAccountName);
        rewardActivity.setModifyAccount(loginAccountName);
        rewardActivity.setCreateTime(date);
        rewardActivity.setModifyTime(date);
        this.rewardActivityRepository.save((Object)rewardActivity);
        productEntities.stream().forEach(item -> item.setRewardActivityId(rewardActivity.getId()));
        this.rewardActivityProductService.createBatch(productEntities);
        prize.stream().forEach(item -> item.setRewardActivityId(rewardActivity.getId()));
        this.rewardActivityPrizeService.createBatch(prize);
        return rewardActivity;
    }

    @Override
    public Page<RewardActivityEntity> findByConditions(RewardActivityDto dto, Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.rewardActivityRepository.findByConditions(dto, pageable);
    }

    @Override
    @Transactional
    public RewardActivityEntity update(RewardActivityEntity rewardActivity) {
        this.updateValidate(rewardActivity);
        RewardActivityEntity old = this.rewardActivityRepository.findById(rewardActivity.getId());
        Validate.notNull((Object)((Object)old), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        old.setActivityName(rewardActivity.getActivityName());
        old.setStartTime(rewardActivity.getStartTime());
        old.setEndTime(rewardActivity.getEndTime());
        old.setActivityDescription(rewardActivity.getActivityDescription());
        old.setModifyTime(new Date());
        old.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.rewardActivityRepository.updateById((Object)old);
        Set<RewardActivityPrizeEntity> prize = rewardActivity.getPrize();
        this.rewardActivityPrizeService.updateBatch(prize);
        return null;
    }

    @Override
    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rewardActivityRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
    }

    @Override
    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String id : ids) {
            RewardActivityEntity rewardActivity = this.findDetailById(id);
            Set<RewardActivityProductEntity> productEntities = rewardActivity.getProductEntities();
            List<String> productCods = productEntities.stream().map(RewardActivityProductEntity::getMaterialCode).collect(Collectors.toList());
            long count = this.rewardActivityRepository.findByProductsAndDateAndId(productCods, rewardActivity.getStartTime(), rewardActivity.getEndTime(), rewardActivity.getId());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)(rewardActivity.getActivityName() + "\u6d3b\u52a8\u91cd\u590d"), (Object[])new Object[0]);
        }
        this.rewardActivityRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
    }

    @Override
    public RewardActivityEntity findDetailById(String id) {
        LinkedHashSet<RewardActivityPrizeEntity> prize;
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RewardActivityEntity activityEntity = this.rewardActivityRepository.findById(id);
        if (activityEntity == null) {
            return null;
        }
        Set<RewardActivityProductEntity> productEntities = this.rewardActivityProductService.findByRewardActivityId(id);
        if (!CollectionUtils.isEmpty(productEntities)) {
            activityEntity.setProductEntities(productEntities);
        }
        if (!CollectionUtils.isEmpty(prize = this.rewardActivityPrizeService.findDetailByRewardActivityId(id))) {
            activityEntity.setPrize(prize);
        }
        return activityEntity;
    }

    @Override
    public RewardActivityEntity findDetailByTime(String productCode) {
        LinkedHashSet<RewardActivityPrizeEntity> prize;
        RewardActivityEntity activityEntity = this.rewardActivityRepository.findByTime(productCode, new Date());
        if (activityEntity == null) {
            return null;
        }
        Set<RewardActivityProductEntity> productEntities = this.rewardActivityProductService.findByRewardActivityId(activityEntity.getId());
        if (!CollectionUtils.isEmpty(productEntities)) {
            activityEntity.setProductEntities(productEntities);
        }
        if (!CollectionUtils.isEmpty(prize = this.rewardActivityPrizeService.findDetailByRewardActivityId(activityEntity.getId()))) {
            activityEntity.setPrize(prize);
        }
        return activityEntity;
    }

    @Override
    public RewardActivityEntity findByActivityCode(String activityCode) {
        if (StringUtils.isBlank((CharSequence)activityCode)) {
            return null;
        }
        return this.rewardActivityRepository.findByActivityCode(activityCode);
    }

    private void updateValidate(RewardActivityEntity rewardActivity) {
        Validate.notNull((Object)((Object)rewardActivity), (String)"\u7f16\u8f91\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardActivity.getId(), (String)"\u7f16\u8f91\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardActivity.getActivityName(), (String)"\u7f16\u8f91\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardActivity.getStartTime(), (String)"\u7f16\u8f91\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardActivity.getEndTime(), (String)"\u7f16\u8f91\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardActivity.getProductType(), (String)"\u7f16\u8f91\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<RewardActivityProductEntity> productEntities = rewardActivity.getProductEntities();
        List<String> productCods = productEntities.stream().map(RewardActivityProductEntity::getMaterialCode).collect(Collectors.toList());
        long count = this.rewardActivityRepository.findByProductsAndDateAndId(productCods, rewardActivity.getStartTime(), rewardActivity.getEndTime(), rewardActivity.getId());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u91cd\u590d", (Object[])new Object[0]);
    }

    private void createValidate(RewardActivityEntity rewardActivity) {
        Validate.notNull((Object)((Object)rewardActivity), (String)"\u521b\u5efa\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(rewardActivity.getProductEntities(), (String)"\u521b\u5efa\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u53c2\u4e0e\u4ea7\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardActivity.getActivityName(), (String)"\u521b\u5efa\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardActivity.getStartTime(), (String)"\u521b\u5efa\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)rewardActivity.getEndTime(), (String)"\u521b\u5efa\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rewardActivity.getProductType(), (String)"\u521b\u5efa\u5956\u52b1\u914d\u7f6e\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set<RewardActivityProductEntity> productEntities = rewardActivity.getProductEntities();
        List<String> productCods = productEntities.stream().map(RewardActivityProductEntity::getMaterialCode).collect(Collectors.toList());
        long count = this.rewardActivityRepository.findByProductsAndDate(productCods, rewardActivity.getStartTime(), rewardActivity.getEndTime());
        Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u91cd\u590d", (Object[])new Object[0]);
    }
}

