/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityPrizeProductRepository;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeProductService;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardActivityPrizeProductServiceImpl
implements RewardActivityPrizeProductService {
    @Autowired
    private RewardActivityPrizeProductRepository rewardActivityPrizeProductRepository;

    @Override
    @Transactional
    public void createBatch(Set<RewardActivityPrizeProductEntity> set) {
        this.validate(set);
        this.rewardActivityPrizeProductRepository.saveBatch(set);
    }

    @Override
    public Page<RewardActivityPrizeProductEntity> findByConditions(String activityCode, Integer prizeLevel, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)activityCode) || prizeLevel == null) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        return this.rewardActivityPrizeProductRepository.findByConditions(activityCode, prizeLevel, pageable);
    }

    @Override
    public Set<RewardActivityPrizeProductEntity> findByRewardActivityPrizeId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Sets.newHashSet();
        }
        return this.rewardActivityPrizeProductRepository.findByRewardActivityPrizeId(id);
    }

    private void validate(Set<RewardActivityPrizeProductEntity> set) {
        Validate.notEmpty(set, (String)"\u5956\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (RewardActivityPrizeProductEntity item : set) {
            Validate.notBlank((CharSequence)item.getProductCode(), (String)"\u5956\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getProductName(), (String)"\u5956\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

