/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.actual.local.service.internal;

import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityProductEntity;
import com.biz.crm.cps.business.activity.actual.local.repository.RewardActivityProductRepository;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityProductService;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardActivityProductServiceImpl
implements RewardActivityProductService {
    @Autowired
    private RewardActivityProductRepository rewardActivityProductRepository;

    @Override
    @Transactional
    public void createBatch(Set<RewardActivityProductEntity> productEntities) {
        this.validate(productEntities);
        this.rewardActivityProductRepository.saveBatch(productEntities);
    }

    @Override
    public Set<RewardActivityProductEntity> findByRewardActivityId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Sets.newHashSet();
        }
        return this.rewardActivityProductRepository.findByRewardActivityId(id);
    }

    private void validate(Set<RewardActivityProductEntity> productEntities) {
        Validate.notEmpty(productEntities, (String)"\u5956\u52b1\u6d3b\u52a8\u53c2\u4e0e\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (RewardActivityProductEntity item : productEntities) {
            Validate.notBlank((CharSequence)item.getMaterialCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getMaterialName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }
}

