/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.actual.local.service.observer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeEntity;
import com.biz.crm.cps.business.activity.actual.local.entity.RewardActivityPrizeProductEntity;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityActualService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeProductService;
import com.biz.crm.cps.business.activity.actual.local.service.RewardActivityPrizeService;
import com.biz.crm.cps.business.activity.actual.sdk.constant.RewardTypeEnum;
import com.biz.crm.cps.business.activity.actual.sdk.event.RandomQuotaComputeEventListener;
import com.biz.crm.cps.business.activity.sdk.dto.ActivityRandomDto;
import com.biz.crm.cps.business.activity.sdk.dto.ActivityRewardConditionDto;
import com.biz.crm.cps.business.activity.sdk.dto.LotteryDto;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityMountRegister;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityRewardServiceObserver;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityServiceObserver;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActualActivityServiceObserverImpl
implements ActivityServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(ActualActivityServiceObserverImpl.class);
    @Autowired
    @Qualifier(value="RewardActivityActualMountRegisterServiceImpl")
    private ActivityMountRegister activityMountRegister;
    @Autowired(required=false)
    private List<RandomQuotaComputeEventListener> randomQuotaComputeEventListeners;
    @Autowired
    private RewardActivityPrizeService rewardActivityPrizeService;
    @Autowired
    private ActivityRewardServiceObserver activityRewardServiceObserver;
    @Autowired
    private RewardActivityActualService rewardActivityActualService;
    @Autowired
    private RewardActivityPrizeProductService rewardActivityPrizeProductService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Transactional
    public Integer onLottery(LotteryDto lotteryDto) {
        Validate.notNull((Object)lotteryDto, (String)"\u5956\u52b1\u6761\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)lotteryDto.getActivityMethodFlag(), (String)"\u6d3b\u52a8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)lotteryDto.getActivityCode(), (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)lotteryDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (StringUtil.equals((String)lotteryDto.getActivityMethodFlag(), (String)this.activityMountRegister.getFlag())) {
            ArrayList<ActivityRandomDto> params = new ArrayList<ActivityRandomDto>();
            Set<RewardActivityPrizeEntity> prizes = this.rewardActivityPrizeService.findDetailByActivityCode(lotteryDto.getActivityCode());
            for (RewardActivityPrizeEntity prize : prizes) {
                ActivityRandomDto dto = new ActivityRandomDto();
                dto.setCash(prize.getPrizeLevel());
                dto.setPercent(prize.getProbability());
                params.add(dto);
            }
            if (!CollectionUtils.isEmpty(this.randomQuotaComputeEventListeners)) {
                for (RandomQuotaComputeEventListener randomQuotaComputeEventListener : this.randomQuotaComputeEventListeners) {
                    BigDecimal amount = randomQuotaComputeEventListener.onExecute(params);
                    log.info("\u673a\u7387\u8ba1\u7b97\u7684\u503c====" + amount);
                    if (amount == null) continue;
                    if (amount.intValue() != 1) {
                        RewardActivityPrizeEntity prizeEntity = this.rewardActivityPrizeService.findByActivityCodeAndPrizeLevel(lotteryDto.getActivityCode(), amount.intValue());
                        this.rewardActivityPrizeService.updateInventoryById(prizeEntity.getId());
                        List<ActivityRewardConditionDto> list = this.buildDto(lotteryDto, prizeEntity);
                        log.info("\u5956\u52b1\u8bb0\u5f55======{}", (Object)JSON.toJSONString(list));
                        this.activityRewardServiceObserver.createRewardRecord(list);
                    }
                    return amount.intValue();
                }
            }
        }
        return null;
    }

    private List<ActivityRewardConditionDto> buildDto(LotteryDto lotteryDto, RewardActivityPrizeEntity prizeEntity) {
        Set<RewardActivityPrizeProductEntity> prizeProduct = this.rewardActivityPrizeProductService.findByRewardActivityPrizeId(prizeEntity.getId());
        ArrayList<ActivityRewardConditionDto> list = new ArrayList<ActivityRewardConditionDto>();
        if (!CollectionUtils.isEmpty(prizeProduct)) {
            LoginUserDetails loginUser = this.loginUserService.getLoginUser();
            String shipmentNum = "";
            if (Objects.nonNull(this.generateCodeService)) {
                shipmentNum = (String)this.generateCodeService.generateCode("shipment_num", 1).get(0);
            }
            for (RewardActivityPrizeProductEntity item : prizeProduct) {
                ActivityRewardConditionDto dto = new ActivityRewardConditionDto();
                dto.setShipmentNum(shipmentNum);
                dto.setAwardConditionFlag("fixedAmount");
                dto.setRewardData("1");
                dto.setParticipatorFlag(ParticipatorTypeEnum.getByKey((String)loginUser.getUsertype()).getDictCode());
                dto.setParticipatorName(loginUser.getConsumerName());
                dto.setRewardMethodFlag("gift");
                dto.setRewardMethodName(lotteryDto.getRewardMethodName());
                dto.setActualParticipatorCode(loginUser.getConsumerCode());
                dto.setActualParticipatorFlag(lotteryDto.getActualParticipatorFlag());
                dto.setGiftCode(item.getProductCode());
                dto.setTriggerAction("activityReward");
                dto.setTriggerObject(lotteryDto.getActivityCode());
                dto.setRewardCode(prizeEntity.getId());
                dto.setRecordCode(lotteryDto.getRecordCode());
                list.add(dto);
            }
            if (prizeEntity.getReverseType() != null && prizeEntity.getReverse() != null) {
                ArrayList<ActivityRewardConditionDto> reverseList = new ArrayList<ActivityRewardConditionDto>();
                ActivityRewardConditionDto reverseDto = new ActivityRewardConditionDto();
                reverseDto.setParticipatorFlag("2");
                reverseDto.setAwardConditionFlag("fixedAmount");
                reverseDto.setParticipatorName(loginUser.getConsumerName());
                reverseDto.setRewardMethodName(lotteryDto.getRewardMethodName());
                reverseDto.setActualParticipatorFlag(lotteryDto.getParticipatorFlag());
                reverseDto.setActualParticipatorCode(loginUser.getConsumerCode());
                RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getByDictCode((String)prizeEntity.getReverseType().toString());
                reverseDto.setRewardMethodFlag(rewardTypeEnum.getKey());
                reverseDto.setRewardData(prizeEntity.getReverse().toString());
                reverseDto.setTriggerAction("activityRewardReverse");
                reverseDto.setRecordCode(lotteryDto.getRecordCode());
                reverseList.add(reverseDto);
                ActivityRewardConditionDto activityRewardConditionDto = (ActivityRewardConditionDto)list.get(0);
                activityRewardConditionDto.setActivityRewardConditionDtos(reverseList);
            }
        }
        return list;
    }
}

