package com.biz.crm.cps.business.activity.actual.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 中奖
 * @author zxw
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityReceiveVo", description = "中奖")
public class RewardActivityReceiveVo {

  /**
   * 中奖流水号
   */
  @ApiModelProperty(name = "code", value = "中奖流水号")
  private String code;

  /**
   * 抽奖活动编码
   */
  @ApiModelProperty(name = "activityCode", value = "抽奖活动编码")
  private String activityCode;

  /**
   * 抽奖活动名称
   */
  @ApiModelProperty(name = "activityName", value = "抽奖活动名称")
  private String activityName;

  /**
   * 消费者ID
   */
  @ApiModelProperty(name = "consumerId", value = "消费者ID")
  private String consumerId;

  /**
   * 消费者编码
   */
  @ApiModelProperty(name = "consumerCode", value = "消费者编码")
  private String consumerCode;

  /**
   * 消费者微信昵称
   */
  @ApiModelProperty(name = "consumerWxName", value = "消费者微信昵称")
  private String consumerWxName;

  /**
   * 消费者手机号
   */
  @ApiModelProperty(name = "consumerPhone", value = "消费者手机号")
  private String consumerPhone;

  /**
   * 扫码产品编码
   */
  @ApiModelProperty(name = "scanProductCode", value = "扫码产品编码")
  private String scanProductCode;

  /**
   * 扫码产品名称
   */
  @ApiModelProperty(name = "scanProductName", value = "扫码产品名称")
  private String scanProductName;

  /**
   * 奖品等级
   */
  @ApiModelProperty(name = "prizeLevelName", value = "奖品等级")
  private String prizeLevelName;

  /**
   * 名称
   */
  @ApiModelProperty("名称")
  private String productName;

  /**
   * prizeId
   */
  @ApiModelProperty("prizeId")
  private String prizeId;

  /**
   * 价值
   */
  @ApiModelProperty(name = "amount", value = "价值")
  private BigDecimal amount;

  /**
   * 奖励数量
   */
  @ApiModelProperty(name = "quantity", value = "奖励数量")
  private BigDecimal quantity;

  /**
   * 创建时间
   */
  @ApiModelProperty(name = "createTime", value = "创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date createTime;
}
