package com.biz.crm.cps.business.activity.local.controller;

import com.biz.crm.cps.business.activity.sdk.dto.LotteryDto;
import com.biz.crm.cps.business.activity.sdk.service.RewardActivityLotteryService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 抽奖
 * @Author: zengxingwang
 * @Date: 2021/10/25 20:55
 */
@Api(tags = "抽奖")
@Slf4j
@RestController
@RequestMapping("/v1/activity/activityLottery")
public class RewardActivityLotteryController {

  @Autowired
  private RewardActivityLotteryService rewardActivityLotteryService;

  /**
   * 抽奖
   */
  @ApiOperation(value = "抽奖")
  @PostMapping(value="lottery")
  public Result<Integer> lottery(@RequestBody LotteryDto lotteryDto) {
    try {
      Integer current = rewardActivityLotteryService.lottery(lotteryDto);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

}
