package com.biz.crm.cps.business.activity.local.controller;

import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 抽奖次数
 * @Author: zengxingwang
 * @Date: 2021/10/25 20:45
 */
@Api(tags = "抽奖次数")
@Slf4j
@RestController
@RequestMapping("/v1/activity/activityRecord")
public class RewardActivityRecordController {

  @Autowired
  private RewardActivityRecordService rewardActivityRecordService;

  /**
   * 根据活动和参与者查询记录
   */
  @ApiOperation(value = "根据活动和参与者查询记录")
  @GetMapping(value="findByActivityCodeAndParticipatorCode")
  public Result<RewardActivityRecordEntity> findByActivityCodeAndParticipatorCode(@RequestParam(value = "activityCode") String activityCode,
                                                                                  @RequestParam(value = "participatorCode") String participatorCode) {
    try {
      RewardActivityRecordEntity current = rewardActivityRecordService.findByActivityCodeAndParticipatorCode(activityCode, participatorCode);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
