package com.biz.crm.cps.business.activity.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 活动奖励次数记录
 * @Author: zengxingwang
 * @Date: 2021/10/25 14:29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "RewardActivityRecordEntity", description = "活动奖励次数记录")
@TableName("reward_activity_record")
public class RewardActivityRecordEntity extends UuidOpEntity {

  /**
   * 抽奖活动编码
   */
  @ApiModelProperty(name = "activityCode", value = "抽奖活动编码")
  @TableField(value = "activity_code")
  private String activityCode;

  /**
   * 抽奖活动名称
   */
  @ApiModelProperty(name = "activityName", value = "抽奖活动名称")
  @TableField(value = "activity_name")
  private String activityName;

  /**
   * 参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)
   */
  @ApiModelProperty("参与者类型：(c-经销商，terminal-终端用户，consumer-消费者)")
  @TableField(value = "participator_type")
  private String participatorType;

  /**
   * 参与者编码
   */
  @ApiModelProperty("参与者编码")
  @TableField(value = "participator_code")
  private String participatorCode;

  /**
   * 抽奖次数
   */
  @ApiModelProperty(name = "activityCount", value = "抽奖次数")
  @TableField(value = "activity_count")
  private Integer activityCount;

  /**
   * 剩余抽奖次数
   */
  @ApiModelProperty(name = "remainingCount", value = "剩余抽奖次数")
  @TableField(value = "remaining_count")
  private Integer remainingCount;
}
