package com.biz.crm.cps.business.activity.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.mapper.RewardActivityRecordMapper;
import com.biz.crm.cps.business.activity.sdk.constant.CountStatusEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 活动奖励次数记录实现持久化
 * @Author: zengxingwang
 * @Date: 2021/10/25 15:07
 */
@Component
public class RewardActivityRecordRepository extends ServiceImpl<RewardActivityRecordMapper, RewardActivityRecordEntity> {

  @Autowired
  private RewardActivityRecordMapper rewardActivityRecordMapper;

  /**
   * 根据活动和参与者查询记录
   * @param activityCode
   * @param participatorCode
   * @return
   */
  public RewardActivityRecordEntity findByActivityCodeAndParticipatorCode(String activityCode, String participatorCode) {
    QueryWrapper<RewardActivityRecordEntity> wrapper = new QueryWrapper();
    wrapper.eq("activity_code", activityCode);
    wrapper.eq("participator_code", participatorCode);
    return this.getOne(wrapper);
  }

  /**
   * 修改抽奖次数
   * @param activityCode
   * @param key
   */
  public void updateCount(String activityCode, String participatorCode, String key) {
    if(CountStatusEnum.ADD.getKey().equals(key)) {
      //默认加一
      rewardActivityRecordMapper.updateAddByActivityCode(activityCode, participatorCode);
    }else {
      //默认减一
      rewardActivityRecordMapper.updateSubtractByActivityCode(activityCode, participatorCode);
    }
  }
}
