package com.biz.crm.cps.business.activity.local.service;

import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;

/**
 * 活动奖励次数记录接口定义
 * @Author: zengxingwang
 * @Date: 2021/10/25 15:02
 */
public interface RewardActivityRecordService {

  /**
   * 活动奖励次数记录保存
   * @param record
   * @return
   */
  RewardActivityRecordEntity create(RewardActivityRecordEntity record);

  /**
   * 根据活动和参与者查询记录
   * @param activityCode
   * @param participatorCode
   * @return
   */
  RewardActivityRecordEntity findByActivityCodeAndParticipatorCode(String activityCode, String participatorCode);

  /**
   * 修改抽奖次数
   * @param activityCode
   * @param key
   */
  void updateCount(String activityCode, String participatorCode, String key);
}
