package com.biz.crm.cps.business.activity.local.service.internal;

import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.activity.sdk.constant.CountStatusEnum;
import com.biz.crm.cps.business.activity.sdk.dto.LotteryDto;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityServiceObserver;
import com.biz.crm.cps.business.activity.sdk.service.RewardActivityLotteryService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Author: zengxingwang
 * @Date: 2021/10/26 9:43
 */
@Service
public class RewardActivityLotteryServiceImpl implements RewardActivityLotteryService {

  @Autowired(required = false)
  private List<ActivityServiceObserver> activityServiceObservers;
  @Autowired
  private RewardActivityRecordService rewardActivityRecordService;

  /**
   * @param lotteryDto
   * @return
   */
  @Override
  @Transactional
  public Integer lottery(LotteryDto lotteryDto) {
    Validate.notNull(lotteryDto, "抽奖时，参入数据不能为空");
    Validate.notBlank(lotteryDto.getActivityCode(), "抽奖时，活动编码不能为空");
    Validate.notNull(lotteryDto.getParticipatorCode(), "抽奖时，参与者编码不能为空");
    Validate.notNull(lotteryDto.getActivityMethodFlag(), "抽奖时，抽奖方式不能为空");
    RewardActivityRecordEntity recordEntity = rewardActivityRecordService.findByActivityCodeAndParticipatorCode(lotteryDto.getActivityCode(), lotteryDto.getParticipatorCode());
    Validate.notNull(recordEntity, "未找到对应抽奖活动");
    Validate.isTrue(recordEntity.getRemainingCount() > 0, "抽奖次数必须大于0");
    if (!CollectionUtils.isEmpty(this.activityServiceObservers)) {
      //扣减次数
      rewardActivityRecordService.updateCount(recordEntity.getActivityCode(), recordEntity.getParticipatorCode(), CountStatusEnum.SUBTRACT.getKey());
      for (ActivityServiceObserver activityServiceObserver : this.activityServiceObservers) {
        Integer a = activityServiceObserver.onLottery(lotteryDto);
        if(a != null){
          return a;
        }
      }
    }
    return null;
  }
}
