package com.biz.crm.cps.business.activity.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.repository.RewardActivityRecordRepository;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 活动奖励次数记录接口实现
 * @Author: zengxingwang
 * @Date: 2021/10/25 15:04
 */
@Service
public class RewardActivityRecordServiceImpl implements RewardActivityRecordService {

  @Autowired
  private RewardActivityRecordRepository rewardActivityRecordRepository;
  @Autowired
  private ConsumerVoService consumerVoService;
  @Autowired
  private LoginUserService loginUserService;
  /**
   * 活动奖励次数记录保存
   * @param record
   * @return
   */
  @Override
  @Transactional
  public RewardActivityRecordEntity create(RewardActivityRecordEntity record) {
    this.validate(record);
    rewardActivityRecordRepository.save(record);
    return record;
  }

  /**
   * 根据活动和参与者查询记录
   * @param activityCode
   * @param participatorCode
   * @return
   */
  @Override
  public RewardActivityRecordEntity findByActivityCodeAndParticipatorCode(String activityCode, String participatorCode) {
    if(StringUtils.isBlank(activityCode) || StringUtils.isBlank(participatorCode)){
      return null;
    }
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    if(loginUser.getUsertype().equals(ParticipatorTypeEnum.CONSUMER.getKey())){
      ConsumerVo consumerVo = consumerVoService.findByExternalId(participatorCode);
      if(consumerVo == null){
        return null;
      }
      participatorCode = consumerVo.getConsumerCode();
    }
    return rewardActivityRecordRepository.findByActivityCodeAndParticipatorCode(activityCode, participatorCode);
  }

  /**
   * 修改抽奖次数
   * @param activityCode
   * @param key
   */
  @Override
  @Transactional
  public void updateCount(String activityCode, String participatorCode, String key) {
    Validate.notBlank(activityCode, "活动编码不能为空");
    Validate.notBlank(participatorCode, "参与者编码不能为空");
    Validate.notBlank(key, "修改类型不能为空");
    rewardActivityRecordRepository.updateCount(activityCode, participatorCode, key);
  }

  /**
   * 验证数据
   * @param record
   */
  private void validate(RewardActivityRecordEntity record) {
  }
}
