package com.biz.crm.cps.business.activity.local.service.notifier;

import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.activity.sdk.constant.CountStatusEnum;
import com.biz.crm.cps.business.activity.sdk.event.ScanCodeActivityEventListener;
import com.biz.crm.cps.business.activity.sdk.vo.RewardActivityRecordVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionStrategyDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 奖励活动扫码事件实现处理
 * @Author: zengxingwang
 * @Date: 2021/10/25 14:24
 */
@Component
public class RewardActivityEventListenerImpl implements ScanCodeRecordEventListener {

  @Autowired
  private RewardActivityRecordService rewardActivityRecordService;
  @Autowired(required = false)
  private List<ScanCodeActivityEventListener> scanCodeActivityEventListeners;
  @Autowired
  private ConsumerVoService consumerVoService;

  @Override
  public void onSuccessScan(ScanCodeRecordEventDto dto) {
    //根据时间和产品获取有效活动(可能会有多种，目前只处理实物一种)
    RewardActivityRecordVo activity = null;
    if (!CollectionUtils.isEmpty(scanCodeActivityEventListeners)) {
      for (ScanCodeActivityEventListener scanCodeActivityEventListener : scanCodeActivityEventListeners) {
        activity = scanCodeActivityEventListener.onFindActivity(dto.getProductCode(), new Date());
      }
    }
    if(activity == null){
      return;
    }
    //数据转换
    RewardActivityRecordEntity record = this.buildRewardActivityRecordEntity(dto, activity);
    RewardActivityRecordEntity entity = rewardActivityRecordService.findByActivityCodeAndParticipatorCode(record.getActivityCode(), dto.getScanParticipatorCode());
    if(entity == null){
      record.setActivityCount(1);
      record.setRemainingCount(1);
      rewardActivityRecordService.create(record);
    }else {
      rewardActivityRecordService.updateCount(entity.getActivityCode(), entity.getParticipatorCode(), CountStatusEnum.ADD.getKey());
    }
  }

  /**
   * 数据转换
   * @param dto
   * @return
   */
  private RewardActivityRecordEntity buildRewardActivityRecordEntity(ScanCodeRecordEventDto dto, RewardActivityRecordVo recordVo) {
    RewardActivityRecordEntity entity = new RewardActivityRecordEntity();
    if(dto.getParticipatorType().equals(ParticipatorTypeEnum.CONSUMER.getKey())){
      ConsumerVo consumerVo = consumerVoService.findByExternalId(dto.getScanParticipatorCode());
      entity.setParticipatorCode(consumerVo.getConsumerCode());
    }else {
      entity.setParticipatorCode(dto.getScanParticipatorCode());
    }
    entity.setActivityCode(recordVo.getActivityCode());
    entity.setActivityName(recordVo.getActivityName());
    entity.setParticipatorType(dto.getParticipatorType());
    return entity;
  }

  @Override
  public void onFailScan(ScanCodeRecordEventDto dto) {

  }
}
