/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.local.service.internal;

import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.activity.sdk.constant.CountStatusEnum;
import com.biz.crm.cps.business.activity.sdk.dto.LotteryDto;
import com.biz.crm.cps.business.activity.sdk.observer.ActivityServiceObserver;
import com.biz.crm.cps.business.activity.sdk.service.RewardActivityLotteryService;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RewardActivityLotteryServiceImpl
implements RewardActivityLotteryService {
    private static final Logger log = LoggerFactory.getLogger(RewardActivityLotteryServiceImpl.class);
    @Autowired(required=false)
    private List<ActivityServiceObserver> activityServiceObservers;
    @Autowired
    private RewardActivityRecordService rewardActivityRecordService;

    @Transactional
    public Integer lottery(LotteryDto lotteryDto) {
        Validate.notNull((Object)lotteryDto, (String)"\u62bd\u5956\u65f6\uff0c\u53c2\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)lotteryDto.getActivityCode(), (String)"\u62bd\u5956\u65f6\uff0c\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)lotteryDto.getParticipatorCode(), (String)"\u62bd\u5956\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)lotteryDto.getActivityMethodFlag(), (String)"\u62bd\u5956\u65f6\uff0c\u62bd\u5956\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RewardActivityRecordEntity recordEntity = this.rewardActivityRecordService.findByActivityCodeAndParticipatorCode(lotteryDto.getActivityCode(), lotteryDto.getParticipatorCode());
        Validate.notNull((Object)((Object)recordEntity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u62bd\u5956\u6d3b\u52a8", (Object[])new Object[0]);
        Validate.isTrue((recordEntity.getRemainingCount() > 0 ? 1 : 0) != 0, (String)"\u62bd\u5956\u6b21\u6570\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.activityServiceObservers)) {
            this.rewardActivityRecordService.updateCount(recordEntity.getActivityCode(), recordEntity.getParticipatorCode(), CountStatusEnum.SUBTRACT.getKey());
            for (ActivityServiceObserver activityServiceObserver : this.activityServiceObservers) {
                Integer a = activityServiceObserver.onLottery(lotteryDto);
                log.info("\u4e2d\u5956\u9879----" + a);
                if (a == null) continue;
                return a;
            }
        }
        return null;
    }
}

