/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.local.service.internal;

import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.repository.RewardActivityRecordRepository;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RewardActivityRecordServiceImpl
implements RewardActivityRecordService {
    @Autowired
    private RewardActivityRecordRepository rewardActivityRecordRepository;
    @Autowired
    private ConsumerVoService consumerVoService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public RewardActivityRecordEntity create(RewardActivityRecordEntity record) {
        this.validate(record);
        this.rewardActivityRecordRepository.save((Object)record);
        return record;
    }

    @Override
    public RewardActivityRecordEntity findByActivityCodeAndParticipatorCode(String activityCode, String participatorCode) {
        if (StringUtils.isBlank((CharSequence)activityCode) || StringUtils.isBlank((CharSequence)participatorCode)) {
            return null;
        }
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        if (loginUser.getUsertype().equals(ParticipatorTypeEnum.CONSUMER.getKey())) {
            ConsumerVo consumerVo = this.consumerVoService.findByExternalId(participatorCode);
            if (consumerVo == null) {
                return null;
            }
            participatorCode = consumerVo.getConsumerCode();
        }
        return this.rewardActivityRecordRepository.findByActivityCodeAndParticipatorCode(activityCode, participatorCode);
    }

    @Override
    @Transactional
    public void updateCount(String activityCode, String participatorCode, String key) {
        Validate.notBlank((CharSequence)activityCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)key, (String)"\u4fee\u6539\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.rewardActivityRecordRepository.updateCount(activityCode, participatorCode, key);
    }

    private void validate(RewardActivityRecordEntity record) {
    }
}

