/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.activity.local.service.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.activity.local.entity.RewardActivityRecordEntity;
import com.biz.crm.cps.business.activity.local.service.RewardActivityRecordService;
import com.biz.crm.cps.business.activity.sdk.constant.CountStatusEnum;
import com.biz.crm.cps.business.activity.sdk.event.ScanCodeActivityEventListener;
import com.biz.crm.cps.business.activity.sdk.vo.RewardActivityRecordVo;
import com.biz.crm.cps.business.consumer.sdk.service.ConsumerVoService;
import com.biz.crm.cps.business.consumer.sdk.vo.ConsumerVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class RewardActivityEventListenerImpl
implements ScanCodeRecordEventListener {
    private static final Logger log = LoggerFactory.getLogger(RewardActivityEventListenerImpl.class);
    @Autowired
    private RewardActivityRecordService rewardActivityRecordService;
    @Autowired(required=false)
    private List<ScanCodeActivityEventListener> scanCodeActivityEventListeners;
    @Autowired
    private ConsumerVoService consumerVoService;

    public void onSuccessScan(ScanCodeRecordEventDto dto) {
        log.info("\u6839\u636e\u65f6\u95f4\u548c\u4ea7\u54c1\u83b7\u53d6\u6709\u6548\u6d3b\u52a8={}", (Object)JSONObject.toJSONString((Object)dto));
        RewardActivityRecordVo activity = null;
        if (!CollectionUtils.isEmpty(this.scanCodeActivityEventListeners)) {
            for (ScanCodeActivityEventListener scanCodeActivityEventListener : this.scanCodeActivityEventListeners) {
                activity = scanCodeActivityEventListener.onFindActivity(dto.getProductCode(), new Date());
            }
        }
        if (activity == null) {
            return;
        }
        RewardActivityRecordEntity record = this.buildRewardActivityRecordEntity(dto, activity);
        RewardActivityRecordEntity entity = this.rewardActivityRecordService.findByActivityCodeAndParticipatorCode(record.getActivityCode(), dto.getScanParticipatorCode());
        if (entity == null) {
            record.setActivityCount(1);
            record.setRemainingCount(1);
            this.rewardActivityRecordService.create(record);
        } else {
            this.rewardActivityRecordService.updateCount(entity.getActivityCode(), entity.getParticipatorCode(), CountStatusEnum.ADD.getKey());
        }
    }

    private RewardActivityRecordEntity buildRewardActivityRecordEntity(ScanCodeRecordEventDto dto, RewardActivityRecordVo recordVo) {
        RewardActivityRecordEntity entity = new RewardActivityRecordEntity();
        if (dto.getParticipatorType().equals(ParticipatorTypeEnum.CONSUMER.getKey())) {
            ConsumerVo consumerVo = this.consumerVoService.findByExternalId(dto.getScanParticipatorCode());
            entity.setParticipatorCode(consumerVo.getConsumerCode());
        } else {
            entity.setParticipatorCode(dto.getScanParticipatorCode());
        }
        entity.setActivityCode(recordVo.getActivityCode());
        entity.setActivityName(recordVo.getActivityName());
        entity.setParticipatorType(dto.getParticipatorType());
        return entity;
    }

    public void onFailScan(ScanCodeRecordEventDto dto) {
    }
}

