package com.biz.crm.cps.business.activity.scan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.local.service.ScanActivityService;
import com.biz.crm.cps.business.activity.scan.sdk.constant.ScanActivityConstant;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码活动(ScanActivity)表控制层
 *
 * @author sunx
 * @date 2022-02-16 16:39:02
 */
@Slf4j
@Api(tags = "扫码活动: ScanActivity: 扫码活动")
@RestController
@RequestMapping(value = {"/v1/scanActivity/scanActivity"})
public class ScanActivityController {

  @Autowired private ScanActivityService scanActivityService;

  @Autowired private RedisMutexService redisMutexService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ScanActivity>> findByConditions(
      @PageableDefault(50) Pageable pageable, ScanActivityPaginationDto paginationDto) {
    try {
      Page<ScanActivity> result =
          this.scanActivityService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "启用")
  @GetMapping("/enable")
  public Result enable(@RequestParam("id") String id) {
    // 需要加锁
    Validate.isTrue(
        this.redisMutexService.tryLock(
            ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY,
            TimeUnit.SECONDS,
            ScanActivityConstant.TRY_LOCK_OUT_TIME),
        ScanActivityConstant.LOCK_FAIL_MESSAGE);
    try {
      this.scanActivityService.enable(id);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY);
    }
  }

  /**
   * 禁用
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "禁用")
  @GetMapping("/disable")
  public Result disable(@RequestParam("id") String id) {
    // 需要加锁
    Validate.isTrue(
        this.redisMutexService.tryLock(
            ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY,
            TimeUnit.SECONDS,
            ScanActivityConstant.TRY_LOCK_OUT_TIME),
        ScanActivityConstant.LOCK_FAIL_MESSAGE);
    try {
      this.scanActivityService.disable(id);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY);
    }
  }
}
