package com.biz.crm.cps.business.activity.scan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ParticipateActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityListPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityListVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityListVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码活动: ScanActivityListVo: 扫码活动分页列表
 *
 * @author sunx
 * @date 2022/3/28
 */
@Slf4j
@Api(tags = "扫码活动: ScanActivityListVo: 扫码活动分页列表")
@RestController
@RequestMapping(value = {"/v1/scanActivity/scanActivityListVo"})
public class ScanActivityListVoController {

  @Autowired private ScanActivityListVoService scanActivityListVoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ScanActivityListVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, ScanActivityListPaginationDto paginationDto) {
    try {
      Page<ScanActivityListVo> result =
          this.scanActivityListVoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取活动参与人数
   *
   * @param code
   * @return
   */
  @ApiOperation(value = "获取活动参与人数")
  @GetMapping(value = {"/findParticipateNumsByCode"})
  public Result<Map<String, String>> findParticipateNumsByCode(@RequestParam("code") String code) {
    try {
      String num = this.scanActivityListVoService.findParticipateNumsByCode(code);
      Map<String, String> map = Maps.newHashMap();
      map.put("num", num);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 参与活动
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "参与活动")
  @PostMapping(value = {"/participateActivity"})
  public Result participateActivity(@RequestBody ParticipateActivityDto dto) {
    try {
      this.scanActivityListVoService.participateActivity(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
