package com.biz.crm.cps.business.activity.scan.local.controller;

import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码活动物料范围控制层
 *
 * @author sunx
 * @date 2022-02-16 16:39:02
 */
@Slf4j
@Api(tags = "扫码活动物料范围: ScanActivityProductScope: 扫码活动物料范围")
@RestController
@RequestMapping(value = {"/v1/scanActivity/scanActivityProductScope"})
public class ScanActivityProductScopeController {

  @Autowired private ScanActivityProductScopeVoService scanActivityProductScopeVoService;

  /**
   * 获取物料范围类型下拉
   *
   * @return
   */
  @ApiOperation(value = "获取物料范围类型下拉")
  @GetMapping(value = {"/findProductScopeTypeList"})
  public Result<List<ScanActivityDictVo>> findProductScopeTypeList() {
    try {
      return Result.ok(this.scanActivityProductScopeVoService.findProductScopeTypeList());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
