package com.biz.crm.cps.business.activity.scan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.local.entity.ScanActivity;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityProductScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityProductScopeItemVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityProductScopeItemVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码活动物料明细controller
 *
 * @author sunx
 * @date 2022/2/23
 */
@Slf4j
@Api(tags = "扫码活动物料明细: ScanActivityProductScopeItemVo: 扫码活动物料明细")
@RestController
@RequestMapping(value = {"/v1/scanActivity/scanActivityProductScopeItem"})
public class ScanActivityProductScopeItemVoController {

  @Autowired private ScanActivityProductScopeItemVoService scanActivityProductScopeItemVoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ScanActivityProductScopeItemVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      ScanActivityProductScopeItemPaginationDto paginationDto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    paginationDto =
        Optional.ofNullable(paginationDto).orElse(new ScanActivityProductScopeItemPaginationDto());
    paginationDto.setPage(pageable.getPageNumber());
    paginationDto.setSize(pageable.getPageSize());
    try {
      Page<ScanActivityProductScopeItemVo> result =
          this.scanActivityProductScopeItemVoService.findByConditions(paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
