package com.biz.crm.cps.business.activity.scan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityUserScopeItemPaginationDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityUserScopeItemVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityUserScopeItemVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码活动可参与人员明细controller
 *
 * @author sunx
 * @date 2022/2/24
 */
@Slf4j
@Api(tags = "扫码活动可参与人员明细: ScanActivityUserScopeItemVo: 扫码活动可参与人员明细")
@RestController
@RequestMapping(value = {"/v1/scanActivity/scanActivityUserScopeItem"})
public class ScanActivityUserScopeItemVoController {

  @Autowired private ScanActivityUserScopeItemVoService scanActivityUserScopeItemVoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ScanActivityUserScopeItemVo>> findByConditions(
      @PageableDefault(50) Pageable pageable,
      ScanActivityUserScopeItemPaginationDto paginationDto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    paginationDto =
        Optional.ofNullable(paginationDto).orElse(new ScanActivityUserScopeItemPaginationDto());
    paginationDto.setPage(pageable.getPageNumber());
    paginationDto.setSize(pageable.getPageSize());
    try {
      Page<ScanActivityUserScopeItemVo> result =
          this.scanActivityUserScopeItemVoService.findByConditions(paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
