package com.biz.crm.cps.business.activity.scan.local.controller;

import com.biz.crm.cps.business.activity.scan.sdk.constant.ScanActivityConstant;
import com.biz.crm.cps.business.activity.scan.sdk.dto.ScanActivityDto;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityParticipateScopeVoService;
import com.biz.crm.cps.business.activity.scan.sdk.service.ScanActivityVoService;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityDictVo;
import com.biz.crm.cps.business.activity.scan.sdk.vo.ScanActivityVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 扫码活动(ScanActivityVo)表控制层
 *
 * @author sunx
 * @date 2022-02-16 16:39:02
 */
@Slf4j
@Api(tags = "扫码活动: ScanActivityVo: 扫码活动")
@RestController
@RequestMapping(value = {"/v1/scanActivity/scanActivity"})
public class ScanActivityVoController {

  @Autowired private ScanActivityVoService scanActivityVoService;

  @Autowired private ScanActivityParticipateScopeVoService scanActivityParticipateScopeVoService;

  @Autowired private RedisMutexService redisMutexService;

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<ScanActivityVo> findDetailById(@RequestParam("id") String id) {
    try {
      ScanActivityVo vo = this.scanActivityVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据扫码活动编码获取参与明细活动的信息
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "根据扫码活动编码获取参与明细活动的信息")
  @GetMapping(value = {"/findById"})
  public Result<ScanActivityVo> findById(@RequestParam("id") String id) {
    try {
      ScanActivityVo vo = this.scanActivityVoService.findById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "新增")
  @PostMapping(value = "")
  public Result<ScanActivityVo> create(@RequestBody ScanActivityDto dto) {
    // 需要加锁
    Validate.isTrue(
        this.redisMutexService.tryLock(
            ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY,
            TimeUnit.SECONDS,
            ScanActivityConstant.TRY_LOCK_OUT_TIME),
        ScanActivityConstant.LOCK_FAIL_MESSAGE);
    try {
      ScanActivityVo current = this.scanActivityVoService.create(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY);
    }
  }

  /**
   * 编辑
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "编辑")
  @PatchMapping(value = "")
  public Result<ScanActivityVo> update(@RequestBody ScanActivityDto dto) {
    // 需要加锁
    Validate.isTrue(
        this.redisMutexService.tryLock(
            ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY,
            TimeUnit.SECONDS,
            ScanActivityConstant.TRY_LOCK_OUT_TIME),
        ScanActivityConstant.LOCK_FAIL_MESSAGE);
    try {
      ScanActivityVo current = this.scanActivityVoService.update(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(ScanActivityConstant.SCAN_ACTIVITY_TRY_LOCK_KEY);
    }
  }

  /**
   * 获取扫码活动参与对象下拉
   *
   * @return
   */
  @ApiOperation(value = "获取扫码活动参与对象下拉")
  @GetMapping(value = {"/findParticipateObjSelectList"})
  public Result<List<ScanActivityDictVo>> findParticipateObjSelectList() {
    try {
      return Result.ok(this.scanActivityParticipateScopeVoService.findParticipateObjSelectList());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
