package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 扫码活动(ScanActivity)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity")
@Table(
    name = "scan_activity",
    indexes = {
      @Index(name = "scan_activity_index1", columnList = "participate_obj"),
      @Index(name = "scan_activity_index2", columnList = "participate_type"),
      @Index(name = "scan_activity_index3", columnList = "participate_scope"),
      @Index(name = "scan_activity_index4", columnList = "code")
    })
@ApiModel(value = "ScanActivity", description = "扫码活动")
@org.hibernate.annotations.Table(appliesTo = "scan_activity", comment = "扫码活动")
public class ScanActivity extends UuidFlagOpEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "code")
  @Column(name = "code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String code;

  /** 活动名称 */
  @ApiModelProperty("活动名称")
  @TableField(value = "name")
  @Column(name = "name", length = 64, columnDefinition = "varchar(64) COMMENT '活动名称'")
  private String name;

  /** 活动开始时间 */
  @ApiModelProperty("活动开始时间")
  @TableField(value = "start_time")
  @Column(name = "start_time", length = -1, columnDefinition = "datetime COMMENT '活动开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /** 活动结束时间 */
  @ApiModelProperty("活动结束时间")
  @TableField(value = "end_time")
  @Column(name = "end_time", length = -1, columnDefinition = "datetime COMMENT '活动结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /** 参与对象 ScanActivityParticipateObjEnum */
  @ApiModelProperty("参与对象,customer-经销商,terminal-终端")
  @TableField(value = "participate_obj")
  @Column(name = "participate_obj", length = 64, columnDefinition = "varchar(64) COMMENT '参与对象'")
  private String participateObj;

  /** 参与类型 ScanActivityParticipateTypeEnum */
  @ApiModelProperty("参与类型,manual-手动参与,automatic-自动参与")
  @TableField(value = "participate_type")
  @Column(name = "participate_type", length = 64, columnDefinition = "varchar(64) COMMENT '参与类型'")
  private String participateType;

  /** 参与开始时间 */
  @ApiModelProperty("参与开始时间")
  @TableField(value = "participate_start_time")
  @Column(
      name = "participate_start_time",
      length = -1,
      columnDefinition = "datetime COMMENT '参与开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date participateStartTime;

  /** 参与截止时间 */
  @ApiModelProperty("参与截止时间")
  @TableField(value = "participate_end_time")
  @Column(
      name = "participate_end_time",
      length = -1,
      columnDefinition = "datetime COMMENT '参与截止时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date participateEndTime;

  /** 参与范围 ScanActivityScopeEnum */
  @ApiModelProperty("参与范围,all-全部,part-部分,special-指定")
  @TableField(value = "participate_scope")
  @Column(name = "participate_scope", length = 64, columnDefinition = "varchar(64) COMMENT '参与范围'")
  private String participateScope;

  /** 物料范围 ScanActivityScopeEnum */
  @ApiModelProperty("物料范围,part-部分,special-指定")
  @TableField(value = "product_scope")
  @Column(name = "product_scope", length = 64, columnDefinition = "varchar(64) COMMENT '物料范围'")
  private String productScope;

  /** 红包发放账号编码 */
  @ApiModelProperty("红包发放账号编码")
  @TableField(value = "account_code")
  @Column(name = "account_code", length = 64, columnDefinition = "varchar(64) COMMENT '红包发放账号编码'")
  private String accountCode;

  /** 活动状态 ScanActivityStatusEnum */
  @ApiModelProperty("活动状态,default-待开始,running-进行中,finish-已结束")
  @TableField(value = "act_status")
  @Column(name = "act_status", length = 64, columnDefinition = "varchar(64) COMMENT '活动状态'")
  private String actStatus;

  /** 是否限制消费者扫码区域 */
  @ApiModelProperty("是否限制消费者扫码区域")
  @TableField(value = "area_flag")
  @Column(name = "area_flag", columnDefinition = "bit(1) COMMENT '是否限制消费者扫码区域'")
  private Boolean areaFlag;

  /** 参与人员范围 */
  @ApiModelProperty("参与人员范围")
  @TableField(exist = false)
  @Transient
  private List<ScanActivityParticipateScope> participateScopeList;

  /** 参与物料范围 */
  @ApiModelProperty("参与物料范围")
  @TableField(exist = false)
  @Transient
  private List<ScanActivityProductScope> productScopeList;

  /** 奖励配置 */
  @ApiModelProperty("奖励配置")
  @TableField(exist = false)
  @Transient
  private List<ScanActivityReward> rewardList;

  /** 消费者扫码区域配置 */
  @ApiModelProperty("消费者扫码区域配置")
  @TableField(exist = false)
  @Transient
  private List<ScanActivityUserArea> areaList;
}
