package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 扫码活动参与范围配置信息(ScanActivityProductScope)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_participate_scope")
@Table(name = "scan_activity_participate_scope")
@ApiModel(value = "ScanActivityProductScope", description = "扫码活动参与范围配置信息")
@org.hibernate.annotations.Table(
    appliesTo = "scan_activity_participate_scope",
    comment = "扫码活动参与范围配置信息")
public class ScanActivityParticipateScope extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 参与范围类型 ScanActivityParticipateScopeTypeEnum */
  @ApiModelProperty(
      "参与范围类型,"
          + "经销商(组织-org、渠道-channel、标签-tag、经销商-default)"
          + "终端(组织-org、渠道-channel、标签-tag、终端-default)"
          + "导购(组织-org、职位级别-position、导购-default)"
          + "消费者(消费者-default)")
  @TableField(value = "participate_scope_type")
  @Column(
      name = "participate_scope_type",
      length = 64,
      columnDefinition = "varchar(64) COMMENT '参与范围类型'")
  private String participateScopeType;

  /** 关联物料业务编码 */
  @ApiModelProperty("关联物料业务编码")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 64, columnDefinition = "varchar(64) COMMENT '关联物料业务编码'")
  private String relateCode;

  /** 关联业务描述 */
  @ApiModelProperty("关联业务描述")
  @TableField(value = "relate_name")
  @Column(name = "relate_name", length = 64, columnDefinition = "varchar(64) COMMENT '关联业务描述'")
  private String relateName;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;
}
