package com.biz.crm.cps.business.activity.scan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 扫码活动物料范围配置信息(ScanActivityProductScope)实体类
 *
 * @author sunx
 * @since 2022-02-16 16:39:03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("scan_activity_product_scope")
@Table(name = "scan_activity_product_scope")
@ApiModel(value = "ScanActivityProductScope", description = "扫码活动物料范围配置信息")
@org.hibernate.annotations.Table(
    appliesTo = "scan_activity_product_scope",
    comment = "扫码活动物料范围配置信息")
public class ScanActivityProductScope extends BaseIdEntity {

  /** 活动编码 */
  @ApiModelProperty("活动编码")
  @TableField(value = "act_code")
  @Column(name = "act_code", length = 64, columnDefinition = "varchar(64) COMMENT '活动编码'")
  private String actCode;

  /** 范围类型 cps-product-level数据字典 */
  @ApiModelProperty("范围类型，cps-product-level数据字典")
  @TableField(value = "scope_type")
  @Column(name = "scope_type", length = 64, columnDefinition = "varchar(64) COMMENT '范围类型'")
  private String scopeType;

  /** 关联物料业务编码 */
  @ApiModelProperty("关联物料业务编码")
  @TableField(value = "relate_code")
  @Column(name = "relate_code", length = 64, columnDefinition = "varchar(64) COMMENT '关联物料业务编码'")
  private String relateCode;

  /** 关联业务描述 */
  @ApiModelProperty("关联业务描述")
  @TableField(value = "relate_name")
  @Column(name = "relate_name", length = 64, columnDefinition = "varchar(64) COMMENT '关联业务描述'")
  private String relateName;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;
}
